VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ClsPerspective"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
' -------------------------------------------------
' Autor:    Leandro I. Ascierto
' Fecha:    10 de Mayo de 2010
' Web:      www.leandroascierto.com.ar
' -------------------------------------------------
Private Declare Function GdiplusStartup Lib "gdiplus" (ByRef token As Long, ByRef lpInput As GDIPlusStartupInput, Optional ByRef lpOutput As Any) As Long
Private Declare Function GdiplusShutdown Lib "gdiplus" (ByVal token As Long) As Long
Private Declare Function GdipSetInterpolationMode Lib "gdiplus" (ByVal graphics As Long, ByVal InterpolationMode As Long) As Long
Private Declare Function GdipCreateFromHDC Lib "gdiplus" (ByVal hDC As Long, ByRef graphics As Long) As Long
Private Declare Function GdipDeleteGraphics Lib "gdiplus" (ByVal graphics As Long) As Long
Private Declare Function GdipLoadImageFromFile Lib "gdiplus" (ByVal FileName As Long, ByRef image As Long) As Long
Private Declare Function GdipDisposeImage Lib "gdiplus" (ByVal image As Long) As Long
Private Declare Function GdipDrawImageRectRect Lib "GdiPlus.dll" (ByVal mGraphics As Long, ByVal mImage As Long, ByVal mDstx As Single, ByVal mDsty As Single, ByVal mDstwidth As Single, ByVal mDstheight As Single, ByVal mSrcx As Single, ByVal mSrcy As Single, ByVal mSrcwidth As Single, ByVal mSrcheight As Single, ByVal mSrcUnit As Long, ByVal mImageAttributes As Long, ByVal mcallback As Long, ByVal mcallbackData As Long) As Long
Private Declare Function GdipGetImageDimension Lib "gdiplus" (ByVal image As Long, ByRef Width As Single, ByRef Height As Single) As Long
Private Declare Function GdipSetImageAttributesColorMatrix Lib "gdiplus" (ByVal imageattr As Long, ByVal ColorAdjust As Long, ByVal EnableFlag As Boolean, ByRef MatrixColor As COLORMATRIX, MatrixGray As Any, ByVal flags As Long) As Long
Private Declare Function GdipCreateImageAttributes Lib "gdiplus" (ByRef imageattr As Long) As Long
Private Declare Function GdipDisposeImageAttributes Lib "gdiplus" (ByVal imageattr As Long) As Long
Private Declare Function GdipCreateBitmapFromScan0 Lib "gdiplus" (ByVal Width As Long, ByVal Height As Long, ByVal stride As Long, ByVal PixelFormat As Long, scan0 As Any, BITMAP As Long) As Long
Private Declare Function GdipImageRotateFlip Lib "gdiplus" (ByVal image As Long, ByVal rfType As Long) As Long
Private Declare Function GdipGetImageGraphicsContext Lib "GdiPlus.dll" (ByVal mImage As Long, ByRef mGraphics As Long) As Long
Private Declare Function GdipCloneImage Lib "GdiPlus.dll" (ByVal mImage As Long, ByRef mCloneImage As Long) As Long
Private Declare Function GdipDrawRectangle Lib "GdiPlus.dll" (ByVal mGraphics As Long, ByVal mPen As Long, ByVal mX As Single, ByVal mY As Single, ByVal mWidth As Single, ByVal mHeight As Single) As Long
Private Declare Function GdipFillRectangle Lib "GdiPlus.dll" (ByVal mGraphics As Long, ByVal mBrush As Long, ByVal mX As Single, ByVal mY As Single, ByVal mWidth As Single, ByVal mHeight As Single) As Long
Private Declare Function GdipCreatePen1 Lib "GdiPlus.dll" (ByVal mColor As Long, ByVal mWidth As Single, ByVal mUnit As Long, ByRef mPen As Long) As Long
Private Declare Function GdipCreateSolidFill Lib "GdiPlus.dll" (ByVal mColor As Long, ByRef mBrush As Long) As Long
Private Declare Function GdipDeleteBrush Lib "GdiPlus.dll" (ByVal mBrush As Long) As Long
Private Declare Function GdipDeletePen Lib "GdiPlus.dll" (ByVal mPen As Long) As Long
Private Declare Function GdipCreateLineBrushFromRect Lib "GdiPlus.dll" (ByRef mRect As RECTF, ByVal mColor1 As Long, ByVal mColor2 As Long, ByVal mMode As Long, ByRef mWrapMode As Long, ByRef mLineGradient As Long) As Long
Private Declare Function GdipSaveImageToFile Lib "gdiplus" (ByVal image As Long, ByVal FileName As Long, ByRef clsidEncoder As GUID, ByRef encoderParams As Any) As Long
Private Declare Function CLSIDFromString Lib "ole32" (ByVal str As Long, id As GUID) As Long
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)
 
Private Type GDIPlusStartupInput
    GdiPlusVersion                      As Long
    DebugEventCallback                  As Long
    SuppressBackgroundThread            As Long
    SuppressExternalCodecs              As Long
End Type

Private Type RECTF
    Left                As Single
    Top                 As Single
    Width               As Single
    Height              As Single
End Type

Private Type POINTF
    X                   As Single
    Y                   As Single
End Type

Private Type GUID
    Data1               As Long
    Data2               As Integer
    Data3               As Integer
    Data4(0 To 7)       As Byte
End Type
 
Private Type EncoderParameter
    GUID                As GUID
    NumberOfValues      As Long
    type                As Long
    Value               As Long
End Type
 


Private Type COLORMATRIX
    m(0 To 4, 0 To 4)   As Single
End Type

Private Const QualityModeHigh                           As Long = 2&
Private Const InterpolationModeHighQualityBicubic       As Long = QualityModeHigh + 5
Private Const LinearGradientModeVertical                As Long = &H1
Private Const ImageCodecPNG                             As String = "{557CF406-1A04-11D3-9A73-0000F81EF32E}"
Private Const PixelFormat32bppPARGB                     As Long = &HE200B
Private Const GdiPlusVersion                            As Long = 1&
Private Const PI180                                     As Double = 0.01745392 '3,14159265 / 180
 
Dim GdipToken                   As Long
Dim m_hImage                    As Long
Dim m_hImgThumbnail             As Long
Dim m_hImgReflection            As Long
Dim mWidth                      As Single
Dim mHeight                     As Single
Dim mAngle                      As Double
Dim mReflectionBackOpaque       As Boolean
Dim mBorderColor                As OLE_COLOR
Dim mReflectionBackColor        As OLE_COLOR
Dim mThumWidth                  As Long
Dim mThumHeight                 As Long
Dim mReflectionPercent          As Long
Dim mBorderSize                 As Long
Dim mReflectionIntensity        As Long
Dim ReqWidth                    As Long
Dim ReqHeight                   As Long
Dim ReflectionHeight            As Long
Dim mImageIntensity             As Long
Dim mReflectionDistance         As Long

Public Property Let ReflectionDistance(ByVal Value As Long)
    mReflectionDistance = Value
End Property

Public Property Get ReflectionDistance() As Long
    ReflectionDistance = mReflectionDistance
End Property

Public Property Let ReflectionBackColor(ByVal lColor As OLE_COLOR)
    mReflectionBackColor = lColor
End Property

Public Property Get ReflectionBackColor() As OLE_COLOR
    ReflectionBackColor = mReflectionBackColor
End Property

Public Property Let BorderColor(ByVal lColor As OLE_COLOR)
    mBorderColor = lColor
End Property

Public Property Get BorderColor() As OLE_COLOR
    BorderColor = mBorderColor
End Property

Public Property Let ReflectionBackOpaque(ByVal Value As Boolean)
    mReflectionBackOpaque = Value
End Property

Public Property Get ReflectionBackOpaque() As Boolean
    ReflectionBackOpaque = mReflectionBackOpaque
End Property

Public Property Let ReflectionPercent(ByVal lPercent As Long)
    mReflectionPercent = lPercent
End Property

Public Property Get ReflectionPercent() As Long
    ReflectionPercent = mReflectionPercent
End Property

Public Property Let ReflectionIntensity(ByVal lPercent As Long)
    mReflectionIntensity = lPercent
End Property

Public Property Get ReflectionIntensity() As Long
    ReflectionIntensity = mReflectionIntensity
End Property

Public Property Let ImageIntensity(ByVal lPercent As Long)
    mImageIntensity = lPercent
End Property

Public Property Get ImageIntensity() As Long
    ImageIntensity = mImageIntensity
End Property

Public Property Let ThumbnailWidth(ByVal lWidth As Long)
    mThumWidth = lWidth
End Property

Public Property Get ThumbnailWidth() As Long
    ThumbnailWidth = mThumWidth
End Property

Public Property Let ThumbnailHeight(ByVal lHeight As Long)
    mThumHeight = lHeight
End Property

Public Property Get ThumbnailHeight() As Long
    ThumbnailHeight = mThumHeight
End Property

Public Property Let Angle(ByVal lValue As Double)
    mAngle = lValue + 180
End Property

Public Property Get Angle() As Double
    Angle = mAngle - 180
End Property

Public Property Let BorderSize(ByVal lValue As Long)
    mBorderSize = lValue
End Property

Public Property Get BorderSize() As Long
    BorderSize = mBorderSize
End Property

Public Property Get MiniatureWidth() As Long
    MiniatureWidth = ReqWidth
End Property

Public Property Get MiniatureHeight() As Long
    MiniatureHeight = ReqHeight
End Property

Public Property Get OriginalWidth() As Long
    OriginalWidth = mWidth
End Property

Public Property Get OriginalHeight() As Long
    OriginalHeight = mHeight
End Property

Public Property Get hImage() As Long
    hImage = m_hImage
End Property

Public Property Let hImage(ByVal hImg As Long)
    If GdipToken <> 0 Then
        If m_hImage <> 0 Then Call GdipDisposeImage(m_hImage): m_hImage = 0
        m_hImage = hImg
        If (GdipGetImageDimension(m_hImage, mWidth, mHeight) = 0) Then
            If mThumWidth = 0 Then mThumWidth = mWidth * 2
            If mThumHeight = 0 Then mThumHeight = mHeight * 2
            Call CreateThumbnail
            Call CreateReflection
        End If
    End If
End Property

Public Property Get hImageThumbnail() As Long
    hImageThumbnail = m_hImgThumbnail
End Property

Public Property Get hImageReflection() As Long
    hImageReflection = m_hImgReflection
End Property

Public Sub Refresh()
    Call CreateThumbnail
    Call CreateReflection
End Sub

Private Function CreateImagePerspective(ByRef hImg As Long, ByRef hAttributes As Long, ByRef Rect As RECTF) As Boolean
    Dim CosA As Double, CosB As Double
    Dim SinA As Double, SinB As Double
    Dim PT(3)           As POINTF
    Dim i               As Long
    Dim lW              As Double
    Dim FirstH          As Double
    Dim LastH           As Double
    Dim PercentY        As Double
    Dim hGraphics       As Long
    Dim X               As Long
    Dim Y               As Long
    Dim yyy             As Single
    Dim HPerspective    As Long
    Dim lWidth          As Long
    Dim lHeight         As Long
    Dim tMatrixColor    As COLORMATRIX
      
    lWidth = ReqWidth
    lHeight = ReqHeight
         
    CosA = Cos(mAngle * PI180)
    SinA = Sin(mAngle * PI180)
   
    CosB = Cos(90 * PI180)
    SinB = Sin(90 * PI180)
    
    X = (lWidth / 2)
    Y = (lHeight / 2)
     
    PT(0).X = X + lWidth * CosA / 2
    PT(0).Y = Y + lHeight * ((CosB - (CosB * CosA) - SinB) * (5 / (10 - CosB + SinA)))
        
    PT(1).X = PT(0).X
    PT(1).Y = Y + lHeight * ((CosB - (CosB * CosA) + SinB) * (5 / (10 - CosB + SinA)))
    
    PT(2).X = X + lWidth * -CosA / 2
    PT(2).Y = Y + lHeight * ((-CosB - (CosB * CosA) + SinB) * (5 / (10 - CosB - SinA)))
    
    PT(3).X = PT(2).X
    PT(3).Y = Y + lHeight * ((-CosB - (CosB * CosA) - SinB) * (5 / (10 - CosB - SinA)))

    lW = PT(2).X - PT(0).X
    
    FirstH = PT(2).Y - PT(3).Y
    LastH = PT(1).Y - PT(0).Y
            
    yyy = Abs(FirstH - LastH) / 4
       
    HPerspective = lHeight + yyy + mReflectionDistance + ReflectionHeight + 1

    If GdipCreateBitmapFromScan0(lWidth, HPerspective, 0&, PixelFormat32bppPARGB, ByVal 0&, hImg) = 0 Then
    
        If GdipGetImageGraphicsContext(hImg, hGraphics) = 0 Then

            For i = 0 To lWidth
            
                PercentY = ((FirstH - LastH) * i / lWidth)
                GdipDrawImageRectRect hGraphics, m_hImgThumbnail, i, yyy + PT(3).Y + PercentY / 2 + 2, 1, (FirstH - PercentY) - 1, i, -1, 1, lHeight + 4, &H2, 0&, 0&, 0&
                
                If m_hImgReflection <> 0 Then
                    PercentY = ((FirstH - LastH) * (lWidth - i) / lWidth)
                    GdipDrawImageRectRect hGraphics, m_hImgReflection, i, mReflectionDistance + lHeight + yyy + PT(3).Y + PercentY / 2 - 3, 1, ReflectionHeight - yyy + PT(3).Y + PercentY / 2, i, -1, 1, ReflectionHeight + 4, &H2, 0&, 0&, 0&
                End If
                
            Next
            
            Call GdipDeleteGraphics(hGraphics)
        End If

        With Rect
            .Left = (mThumWidth / 2) - Abs(lW / 2)
            .Top = -yyy
            .Width = Abs(lW) + 1
            .Height = HPerspective
        End With
        
        With tMatrixColor
            .m(0, 0) = 1
            .m(1, 1) = 1
            .m(2, 2) = 1
            .m(3, 3) = mImageIntensity / 100
            .m(4, 4) = 1
        End With
        
        If lW < 0 Then
        
            GdipImageRotateFlip hImg, 4&
            
            With tMatrixColor
                .m(0, 4) = -0.1
                .m(1, 4) = -0.1
                .m(2, 4) = -0.1
            End With
            
            If GdipCreateImageAttributes(hAttributes) = 0 Then
                Call GdipSetImageAttributesColorMatrix(hAttributes, 0&, True, tMatrixColor, ByVal 0&, 0&)
            End If
            
        Else
            If mImageIntensity < 100 Then
                If GdipCreateImageAttributes(hAttributes) = 0 Then
                    Call GdipSetImageAttributesColorMatrix(hAttributes, 0&, True, tMatrixColor, ByVal 0&, 0&)
                End If
            End If
        End If

        
    End If
End Function


Sub DrawPerspective(DestHdc As Long, ByVal lLeft As Long, ByVal lTop As Long, Optional ByVal ZoomWidth As Long, Optional ByVal ZoomHeight As Long)
    Dim hGraphics As Long
    Dim hImg As Long
    Dim hAttributes As Long
    Dim Rect As RECTF

    If GdipCreateFromHDC(DestHdc, hGraphics) = 0 Then
    
        CreateImagePerspective hImg, hAttributes, Rect
        
        If hImg <> 0 Then
            GdipSetInterpolationMode hGraphics, InterpolationModeHighQualityBicubic
            With Rect
                Call GdipDrawImageRectRect(hGraphics, hImg, lLeft + .Left, lTop + .Top, .Width + (.Width * ZoomWidth / 100), .Height + (.Height * ZoomHeight / 100), 0, 0, ReqWidth, .Height, &H2, hAttributes, 0&, 0&)
            End With
            
            Call GdipDisposeImage(hImg)
            
        End If
        
        If hAttributes <> 0 Then
            Call GdipDisposeImageAttributes(hAttributes)
        End If
        
        Call GdipDeleteGraphics(hGraphics)
    
    End If
End Sub


Public Function SaveToFile(ByVal DestPath As String) As Boolean

    Dim hBitmap     As Long
    Dim tEncoder    As GUID
    Dim hGraphics As Long
    Dim hImg As Long
    Dim hAttributes As Long
    Dim Rect As RECTF
    
    CreateImagePerspective hImg, hAttributes, Rect

    CLSIDFromString StrPtr(ImageCodecPNG), tEncoder
    
    If hImg <> 0 Then
    
        With Rect

            If GdipCreateBitmapFromScan0(.Width, .Height, 0&, PixelFormat32bppPARGB, ByVal 0, hBitmap) = 0 Then
            
                If GdipGetImageGraphicsContext(hBitmap, hGraphics) = 0 Then
                
                    GdipSetInterpolationMode hGraphics, InterpolationModeHighQualityBicubic
                    
                    Call GdipDrawImageRectRect(hGraphics, hImg, 0, 0, .Width, .Height, 0, 0, ReqWidth, .Height, &H2, hAttributes, 0&, 0&)
                    
                    Call GdipDeleteGraphics(hGraphics)
                    
                    If GdipSaveImageToFile(hBitmap, StrPtr(DestPath), tEncoder, ByVal 0) = 0 Then
                        SaveToFile = True
                    End If
                    
                End If
                
                Call GdipDisposeImage(hBitmap)
                
            End If
            
        End With
        
        Call GdipDisposeImage(hImg)
        
    End If
    
    If hAttributes <> 0 Then
        Call GdipDisposeImageAttributes(hAttributes)
    End If
    
End Function


Public Function LoadPictureFromFile(ByVal sFileName As String) As Boolean
    If GdipToken <> 0 Then
        If m_hImage <> 0 Then Call GdipDisposeImage(m_hImage): m_hImage = 0
        If (GdipLoadImageFromFile(StrPtr(sFileName), m_hImage) = 0) Then
            If (GdipGetImageDimension(m_hImage, mWidth, mHeight) = 0) Then
                LoadPictureFromFile = True
                If mThumWidth = 0 Then mThumWidth = mWidth * 2
                If mThumHeight = 0 Then mThumHeight = mHeight * 2
                Call CreateThumbnail
                Call CreateReflection
            End If
        End If
    End If
End Function


Private Sub CreateThumbnail()

    Dim hGraphics   As Long
    Dim HScale As Double, VScale As Double
    Dim MyScale     As Double

    HScale = (mThumWidth - (mBorderSize * 2)) / mWidth
    VScale = (mThumHeight - (mBorderSize * 2)) / mHeight

    MyScale = IIf(VScale >= HScale, HScale, VScale)
    
    ReqWidth = mWidth * MyScale
    ReqHeight = mHeight * MyScale

    If m_hImgThumbnail <> 0 Then Call GdipDisposeImage(m_hImgThumbnail): m_hImgThumbnail = 0
   
    If GdipCreateBitmapFromScan0(ReqWidth, ReqHeight, 0&, PixelFormat32bppPARGB, ByVal 0, m_hImgThumbnail) = 0 Then
        If GdipGetImageGraphicsContext(m_hImgThumbnail, hGraphics) = 0 Then
            If mBorderSize > 0 Then pvRectangle hGraphics, 0, 0, ReqWidth, ReqHeight
            Call GdipDrawImageRectRect(hGraphics, m_hImage, mBorderSize, mBorderSize, ReqWidth - (mBorderSize * 2), ReqHeight - (mBorderSize * 2), 0, 0, mWidth, mHeight, &H2, 0&, 0&, 0&)
            Call GdipDeleteGraphics(hGraphics)
        End If
    End If
    
End Sub


Private Sub CreateReflection()
    Dim hGraphics       As Long
    Dim col(2)          As Long
    Dim pos(2)          As Single
    Dim hBrush          As Long
    Dim Rect            As RECTF
    Dim lAlpha          As Single
    Dim tMatrixColor    As COLORMATRIX
    Dim hAttributes     As Long
    Dim i               As Long

    If m_hImgReflection <> 0 Then Call GdipDisposeImage(m_hImgReflection): m_hImgReflection = 0
    
    If mReflectionPercent = 0 Or mReflectionIntensity = 0 Then Exit Sub
    
    If GdipCreateBitmapFromScan0(ReqWidth, ReqHeight, 0&, PixelFormat32bppPARGB, ByVal 0, m_hImgReflection) = 0 Then
    
        If GdipGetImageGraphicsContext(m_hImgReflection, hGraphics) = 0 Then
        
            ReflectionHeight = ReqHeight * mReflectionPercent / 100
            
            If mReflectionBackOpaque Then
            
                Call GdipDrawImageRectRect(hGraphics, m_hImgThumbnail, 0, 0, ReqWidth, ReflectionHeight, 0, ReqHeight, ReqWidth, -ReflectionHeight, &H2, 0&, 0&, 0&)
                
                With Rect
                    .Width = ReqWidth
                    .Height = ReflectionHeight
                End With
                
                GdipCreateLineBrushFromRect Rect, ConvertColor(mReflectionBackColor, 100 - mReflectionIntensity), ConvertColor(mReflectionBackColor, 100), LinearGradientModeVertical, &H0, hBrush 'crea una brocha de dos colores
                GdipFillRectangle hGraphics, hBrush, 0, 0, ReqWidth, ReflectionHeight
                Call GdipDeleteBrush(hBrush)
            Else
                With tMatrixColor
                    .m(0, 0) = 1
                    .m(1, 1) = 1
                    .m(2, 2) = 1
                    .m(4, 4) = 1
                End With
                
                If GdipCreateImageAttributes(hAttributes) = 0 Then
                    For i = 0 To ReflectionHeight
                        'lAlpha = (255 * (ReflectionHeight - i) \ ReflectionHeight)
                        
                        lAlpha = 1 - (i * 100 / ReflectionHeight) / 100
                        
                        tMatrixColor.m(3, 3) = (lAlpha * mReflectionIntensity) / 100

                        If GdipSetImageAttributesColorMatrix(hAttributes, 0&, True, tMatrixColor, ByVal 0&, 0&) = 0 Then
                            Call GdipDrawImageRectRect(hGraphics, m_hImgThumbnail, 0, i, ReqWidth, 1, 0, ReqHeight - i, ReqWidth, 1, &H2, hAttributes, 0&, 0&)
                        End If
                    Next
                    Call GdipDisposeImageAttributes(hAttributes)
                End If
            End If
            
            Call GdipDeleteGraphics(hGraphics)
        End If
    End If
    
End Sub


Private Sub pvRectangle(ByVal hGraphics As Long, ByVal X As Long, ByVal Y As Long, ByVal Width As Long, ByVal Height As Long)
    Dim hBrush As Long
    Dim hPen As Long
    
    GdipCreatePen1 ConvertColor(&HCCCCCC, 100), 1, &H2, hPen
    GdipCreateSolidFill ConvertColor(mBorderColor, 100), hBrush
    
    GdipFillRectangle hGraphics, hBrush, X, Y, Width, Height
    GdipDrawRectangle hGraphics, hPen, X, Y, Width - 1, Height - 1
    
    GdipDeletePen hPen
    GdipDeleteBrush hBrush
End Sub


Private Sub Class_Initialize()
    Dim GdipStartupInput As GDIPlusStartupInput
    GdipStartupInput.GdiPlusVersion = GdiPlusVersion
    Call GdiplusStartup(GdipToken, GdipStartupInput, ByVal 0)
    mReflectionPercent = 50
    mReflectionIntensity = 50
    mBorderColor = &HF6F6F6
    mImageIntensity = 100
    Me.Angle = 0
End Sub


Private Sub Class_Terminate()
    If m_hImage <> 0 Then Call GdipDisposeImage(m_hImage)
    If m_hImgThumbnail <> 0 Then Call GdipDisposeImage(m_hImgThumbnail)
    If m_hImgReflection <> 0 Then Call GdipDisposeImage(m_hImgReflection)
    Call GdiplusShutdown(GdipToken)
End Sub


' Funcin para convertir un color long a un BGRA(Blue, Green, Red, Alpha)
Private Function ConvertColor(Color As Long, Opacity As Long) As Long
    Dim BGRA(0 To 3) As Byte
    BGRA(3) = CByte((Abs(Opacity) / 100) * 255)
    BGRA(0) = ((Color \ &H10000) And &HFF)
    BGRA(1) = ((Color \ &H100) And &HFF)
    BGRA(2) = (Color And &HFF)
    CopyMemory ConvertColor, BGRA(0), 4&
End Function

